-----------------------------------------------------------------------------------
/*
Vjebe se rade na bazi AdventureWorksOBP
*/
USE AdventureWorksOBP
GO
-----------------------------------------------------------------------------------

-----------------------------------------------------------------------------------
/* N A P O M E N A
Kod rjeavanja zadataka s transakcijama 
potrebne su dvije SQL skripte, svaka u 
svojoj konekciji te svaka SQL naredba 
treba sadravati redni broj izvravanja
*/
-----------------------------------------------------------------------------------

-----------------------------------------------------------------------------------
-- Zadatak 1.
/*
IZOLACIJSKI NIVOI (1) - SKRIPTA 1
Demonstrirajte problem prljavog itanja na tablici Drzava na retku s IDDrzava = 3. 
Napiite gdje se desilo prljavo itanje.
*/
-- TRANSAKCIJA 1.
-- KORACI KOJI NEDOSTAJU IZVRAVAJU SE U DRUGOJ SKRIPTI
-- 1. 
SET TRANSACTION ISOLATION LEVEL READ COMMITTED
-- 3.
BEGIN TRAN
-- 5.
UPDATE Drzava SET Naziv = 'BIH' WHERE IDDrzava = 3
-- 7.
ROLLBACK TRAN
-----------------------------------------------------------------------------------

-----------------------------------------------------------------------------------
-- Zadatak 2.
/*
IZOLACIJSKI NIVOI (1) - SKRIPTA 1
Demonstrirajte rjeenje problem prljavog itanja na tablici Drzava na retku s IDDrzava = 3. 
Napiite gdje bi se desilo prljavo itanje i kako ste to sprijeili.
*/
-- TRANSAKCIJA 1.
-- KORACI KOJI NEDOSTAJU IZVRAVAJU SE U DRUGOJ SKRIPTI
-- 1. 
SET TRANSACTION ISOLATION LEVEL READ COMMITTED
-- 3.
BEGIN TRAN
-- 5.
UPDATE Drzava SET Naziv = 'BIH' WHERE IDDrzava = 3
-- 7.
ROLLBACK TRAN
-----------------------------------------------------------------------------------

-----------------------------------------------------------------------------------
-- Zadatak 3.
/*
IZOLACIJSKI NIVOI (2) - SKRIPTA 1
Demonstrirajte problem neponovljivog itanja na tablici Drzava na retku s IDDrzava = 3. 
Napiite gdje se desilo neponovljivo itanje.
*/
-- TRANSAKCIJA 1.
-- KORACI KOJI NEDOSTAJU IZVRAVAJU SE U DRUGOJ SKRIPTI
-- 1. 
SET TRANSACTION ISOLATION LEVEL READ COMMITTED
-- 3.
BEGIN TRAN
-- 5.
SELECT * FROM Drzava WHERE IDDrzava = 3 -- Neponovljivo itanje.
-- 8.
SELECT * FROM Drzava WHERE IDDrzava = 3
-- 9.
ROLLBACK TRAN
-----------------------------------------------------------------------------------

-----------------------------------------------------------------------------------
-- Zadatak 4.
/*
IZOLACIJSKI NIVOI (2) - SKRIPTA 1
Demonstrirajte rjeenje problema neponovljivog itanja na tablici Drzava na retku s IDDrzava = 3. 
Napiite gdje bi se desilo neponovljivo itanje.
*/
-- TRANSAKCIJA 1.
-- KORACI KOJI NEDOSTAJU IZVRAVAJU SE U DRUGOJ SKRIPTI
-- 1. 
SET TRANSACTION ISOLATION LEVEL REPEATABLE READ -- Neponovljivo itanje sprjeavamo postavljanjem bilo kojeg izolacijskog nivoa iznad READ COMMITTED.
-- 3.
BEGIN TRAN
-- 5.
SELECT * FROM Drzava WHERE IDDrzava = 1 -- Tu bi se desilo neponovljivo itanje, ali se nee desiti jer sam sada postavio S lokot i drim ga do kraja transakcije.
-- 7.
SELECT * FROM Drzava WHERE IDDrzava = 1
-- 8.
ROLLBACK TRAN
-----------------------------------------------------------------------------------

-----------------------------------------------------------------------------------
-- Zadatak 5.
/*
IZOLACIJSKI NIVOI (2) - SKRIPTA 1
Demonstrirajte problem fantoma na tablici Drzava 
na recima s nazivima koji zapoinju s 'H'. 
Napiite gdje se pojavljuju fantomi.
*/
-- TRANSAKCIJA 1.
-- KORACI KOJI NEDOSTAJU IZVRAVAJU SE U DRUGOJ SKRIPTI
-- 1. 
SET TRANSACTION ISOLATION LEVEL READ COMMITTED
-- 3.
BEGIN TRAN
-- 5.
SELECT * FROM Drzava WHERE Naziv LIKE 'H%' -- vraa 1 redak.
-- 8.
SELECT * FROM Drzava WHERE Naziv LIKE 'H%' -- vraa 2 retka, drugi redak je fantom.
-- 9.
ROLLBACK TRAN
-----------------------------------------------------------------------------------

-----------------------------------------------------------------------------------
-- Zadatak 6.
/*
IZOLACIJSKI NIVOI (2) - SKRIPTA 1
Demonstrirajte rjeenje problema fantoma na tablici Drzava 
na recima s nazivima koji zapoinju s 'H'. 
Napiite gdje bi se pojavili fantomi.
*/
-- TRANSAKCIJA 1.
-- KORACI KOJI NEDOSTAJU IZVRAVAJU SE U DRUGOJ SKRIPTI
-- 1. 
SET TRANSACTION ISOLATION LEVEL SERIALIZABLE -- Fantome sprjeavamo postavljanjem izolacijskog nivoa na SERIALIZABLE.
-- 3.
BEGIN TRAN
-- 5.
SELECT * FROM Drzava WHERE Naziv LIKE 'H%' -- vraa 1 redak i postavlja S lokot na sve retke koji zapoinju s H kojeg e drati do kraja transakcije.
-- 7.
SELECT * FROM Drzava WHERE Naziv LIKE 'H%' -- vraa 1 redak.
-- 8.
ROLLBACK TRAN
-----------------------------------------------------------------------------------
